/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.util;

import javax.swing.table.AbstractTableModel;
import tiled.core.MapLayer;
import tiled.core.MultilayerPlane;
import tiled.mapeditor.Resources;

public class LayerTableModel
extends AbstractTableModel {
    private MultilayerPlane map;
    private static final String[] columnNames = new String[]{Resources.getString("dialog.main.locked.column"), Resources.getString("dialog.main.show.column"), Resources.getString("dialog.main.layername.column")};

    public LayerTableModel() {
    }

    public LayerTableModel(MultilayerPlane map) {
        this.map = map;
    }

    public void setMap(MultilayerPlane map) {
        this.map = map;
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public int getRowCount() {
        if (this.map == null) {
            return 0;
        }
        int totalLayers = this.map.getTotalLayers();
        return totalLayers;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int col) {
        MapLayer layer = this.map.getLayer(this.getRowCount() - row - 1);
        if (layer != null) {
            if (col == 0) {
                return layer.getLocked() || !layer.isVisible();
            }
            if (col == 1) {
                return layer.isVisible();
            }
            if (col == 2) {
                return layer.getName();
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        MapLayer layer = this.map.getLayer(this.getRowCount() - row - 1);
        return col != 0 || layer == null || layer.isVisible();
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        MapLayer layer = this.map.getLayer(this.getRowCount() - row - 1);
        if (layer != null) {
            if (col == 0) {
                layer.setLocked((Boolean)value);
            } else if (col == 1) {
                layer.setVisible((Boolean)value);
            } else if (col == 2) {
                layer.setName(value.toString());
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

